// vna.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <iostream>
#include <string>
#include "winsock2.h"
#include <ws2tcpip.h>
#include <ctime>

#pragma comment (lib, "ws2_32.lib")

using namespace std;

const int RxBufferSize = 8192 + 1;
char RxBuffer[RxBufferSize];
char TxBuffer[RxBufferSize];

bool Transmit(SOCKET& Socket, string &txString)
{
    if(Socket == INVALID_SOCKET) {
       printf("INVALID_SOCKET");
       return false;
    }

	if(txString.length() > RxBufferSize - 1)
	   return false;

	memcpy(TxBuffer, txString.c_str(), txString.length());
	TxBuffer[txString.length()] = '\n'; //newline is needed!

	if(send(Socket, TxBuffer, txString.length() + 1, 0) == SOCKET_ERROR) {
 	   printf("error %d while transmiting data\n", WSAGetLastError());
	   return false;
	}

	Sleep(100);
	return true;
}

bool Receive(SOCKET& Socket, string &rxString)
{
	if(Socket == INVALID_SOCKET) {
       printf("INVALID_SOCKET");
       return false;
    }
    
	rxString = "";
	string tmp;
	int RxByteCount;
	std::time_t start = std::time(NULL);
	while(std::difftime(std::time(NULL), start) < 2) { // < maximum 2 sec wait for receive
		RxByteCount = recv(Socket, RxBuffer, RxBufferSize, 0);
		if(RxByteCount == SOCKET_ERROR) {
			printf("error %d while receiving data\n", WSAGetLastError());
			return false;
		}
       
		RxBuffer[RxByteCount] = '\0';
        tmp = RxBuffer;
	    for(int i = RxByteCount - 1; i >= 0; i--) {
		   if(RxBuffer[i] == '\n') { 
		      tmp.resize(i + 1); 
              rxString += tmp;
	          return true;
		   }
	    }
		rxString += tmp;
	}
	return false;
}

int _tmain(int argc, _TCHAR* argv[])
{
	string      HostName  = "127.0.0.1";
	int         Port      = 5025;

	WSADATA wsaData;
	SOCKET SocketDescr = INVALID_SOCKET;
    hostent* HostInfo = NULL;
	sockaddr_in SrvAddress;

	int err = WSAStartup(MAKEWORD(2,2), &wsaData);
    if (err != NO_ERROR) {
       printf("WSAStartup failed with error\n");
       return -1;
    }

	SocketDescr = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if(SocketDescr == INVALID_SOCKET) {
		WSACleanup();
		printf("can't create socket\n" );
		return -1;
	}

	HostInfo = gethostbyname(HostName.c_str( ));
	if(HostInfo == NULL) {
		printf("error connecting host\n" );
		closesocket(SocketDescr);
	    WSACleanup();
		return -1;
	}

	SrvAddress.sin_family = HostInfo->h_addrtype;
	SrvAddress.sin_port   = htons(Port);
	memcpy((char*)&SrvAddress.sin_addr.s_addr, HostInfo->h_addr_list[0], HostInfo->h_length );

	if(connect(SocketDescr, (sockaddr*)&SrvAddress, sizeof(SrvAddress)) == SOCKET_ERROR) {
		printf("can't connect server\n");
		closesocket(SocketDescr);
	    WSACleanup();
		return -1;
	}

	if (SocketDescr == INVALID_SOCKET) {
        printf("can't connect to server\n");
        WSACleanup();
        return -1;
    }

	string In, Out;
	bool State = Transmit(SocketDescr, string("*CLS"));

    In = "*IDN?"; cout << In << endl;
	State = Transmit(SocketDescr, In);
	if(State) State = Receive(SocketDescr, Out); cout << Out;

	In = "SYST:PRES"; cout << In << endl;
    if(State) State = Transmit(SocketDescr, In);

	In = "SENS:FREQ:STAR 100MHz"; cout << In << endl;
    if(State) State = Transmit(SocketDescr, In);

	In = "SENS:FREQ:STOP 1000MHz"; cout << In << endl;
    if(State) State = Transmit(SocketDescr, In);

	In = "SENS:SWE:POIN 10"; cout << In << endl;
    if(State) State = Transmit(SocketDescr, In);

	In = "SENS:FREQ:STAR?"; cout << In << " ";
	if(State) State = Transmit(SocketDescr, In);
	if(State) State = Receive(SocketDescr, Out); cout << Out;
	
	In = "SENS:FREQ:STOP?"; cout << In << " ";
	if(State) State = Transmit(SocketDescr, In);
	if(State) State = Receive(SocketDescr, Out); cout << Out;
	
	In = "SENS:SWE:POIN?"; cout << In << " ";
	if(State) State = Transmit(SocketDescr, In);
	if(State) State = Receive(SocketDescr, Out); cout << Out;

	In = "SENS:FREQ:DATA?"; cout << In << endl;
	if(State) State = Transmit(SocketDescr, In);
	if(State) State = Receive(SocketDescr, Out); cout << Out;

	In = "CALC:TRAC:DATA:FDAT?"; cout << In << endl;
	if(State) State = Transmit(SocketDescr, In);
	if(State) State = Receive(SocketDescr, Out); cout << Out;

	In = "SYST:ERR?"; cout << In << endl;
	if(State) State = Transmit(SocketDescr, In);
	if(State) State = Receive(SocketDescr, Out); cout << Out;

	cout << "type 'QUIT' or 'quit' for exit" << endl;
	cout << "test command '*IDN?', 'SYST:ERR?' e.c"  << endl;

	while(State) {
       
       In = "";
       getline(cin, In);

	   if(In == "QUIT" || In == "quit")
	      break;

	   if(!Transmit(SocketDescr, In))
	      break; 

	   int Pos = In.find("?", 0);
	   if(Pos > 0) {
          Out = "";
		  if(!Receive(SocketDescr, Out))
		     break;
		  else
		     cout << Out;
	   }
	}

	shutdown(SocketDescr, SD_SEND);
    closesocket(SocketDescr);
	WSACleanup();
	return 0;
}

